# keywords.py
# Copyright 2024 Roger Marsh
# Licence: See LICENCE (BSD licence)

"""Keywords defined by Chess Query Language (CQL).

The initial definition is for CQL-6.0.4 with additions for later versions.

"""

KEYWORDS = frozenset(
    (
        # Keywords defined at CQL-6.0.4.
        "abs",
        "all",
        "ancestor",
        "and",
        "anydirection",
        "attackedby",
        "attacks",
        "between",
        "black",
        "btm",
        "capture",
        "castle",
        "check",
        "child",
        "colortype",
        "comment",
        "connectedpawns",
        "consecutivemoves",
        "count",
        "cql",
        "currentposition",
        "currenttransform",
        "dark",
        "depth",
        "descendant",
        "diagonal",
        "distance",
        "doubledpawns",
        "down",
        "echo",
        "elo",
        "else",
        "enpassant",
        "enpassantsquare",
        "event",
        "false",
        "fen",
        "file",
        "find",
        "firstmatch",
        "flip",
        "flipcolor",
        "fliphorizontal",
        "flipvertical",
        "from",
        "function",
        "gamenumber",
        "hascomment",
        "horizontal",
        "if",
        "in",
        "initial",
        "input",
        "isolatedpawns",
        "lastposition",
        "lca",
        "left",
        "legal",
        "light",
        "line",
        "loop",
        "mainline",
        "makesquare",
        "matchcount",
        "matchstring",
        "mate",
        "max",
        "message",
        "min",
        "move",
        "movenumber",
        "nestban",
        "northeast",
        "northwest",
        "not",
        "notransform",
        "null",
        "orthogonal",
        "or",
        "output",
        "parent",
        "passedpawns",
        "persistent",
        "piece",
        "pieceid",
        "pin",
        "player",
        "ply",
        "position",
        "positionid",
        "power",
        "previous",
        "primary",
        "promote",
        "pseudolegal",
        "quiet",
        "rank",
        "ray",
        "removecomment",
        "result",
        "reversecolor",
        "right",
        "rotate45",
        "rotate90",
        "secondary",
        "shift",
        "shifthorizontal",
        "shiftvertical",
        "sidetomove",
        "silent",
        "singlecolor",
        "site",
        "sort",
        "southeast",
        "southwest",
        "sqrt",
        "square",
        "stalemate",
        "terminal",
        "then",
        "through",
        "to",
        "true",
        "type",
        "up",
        "variations",
        "variation",
        "vertical",
        "virtualmainline",
        "white",
        "wtm",
        "xray",
        "year",
        # Keywords defined at CQL-6.1.
        "ascii",
        "assert",
        "date",
        "dictionary",
        "eco",
        "eventdate",
        "hhdb",
        "indexof",
        "initialposition",
        "int",
        "isbound",
        "isunbound",
        "lowercase",
        "originalcomment",
        "readfile",
        "settag",
        "str",
        "tag",
        "unbind",
        "uppercase",
        "while",
        "writefile",
        # Keywords defined at CQL-6.2.
        "atomic",
        "countmoves",
        "currentmove",
        "element",
        "focus",
        "forall",
        "idealmate",
        "idealstalemate",
        "keepallbest",
        "lastgamenumber",
        "local",
        "modelmate",
        "modelstalemate",
        "nullmove",
        "path",
        "pathcount",
        "pathcountunfocused",
        "pathlastposition",
        "pathstart",
        "piecename",
        "piecepath",
        "puremate",
        "purestalemate",
        "title",
        "try",
        "typename",
        "verbose",
        # keywords listed at CQLi-1.0.3 and available at CQL-6.2
        # but not documented in CQL-6.0.4, CQL-6.1, or CQL-6.2.
        "maindiagonal",
        "offdiagonal",
    )
)
